-- 테이블 mspdb.nxo_box 구조 내보내기
CREATE TABLE IF NOT EXISTS `nxo_box` (
  `n_pid` int(6) unsigned NOT NULL AUTO_INCREMENT COMMENT 'pid',
  `n_cpid` int(3) unsigned DEFAULT NULL COMMENT 'company pid',
  `n_ppid` int(6) unsigned DEFAULT NULL COMMENT 'page pid',
  `n_order` int(3) unsigned NOT NULL DEFAULT 0 COMMENT '1 => area1',
  `n_w` int(4) unsigned NOT NULL DEFAULT 0 COMMENT 'box width 1080',
  `n_h` int(4) unsigned NOT NULL DEFAULT 0 COMMENT 'box height 1920',
  `n_x` int(4) unsigned NOT NULL DEFAULT 0 COMMENT 'box position x',
  `n_y` int(4) unsigned NOT NULL DEFAULT 0 COMMENT 'box position y',
  `n_typcode` varchar(6) DEFAULT NULL COMMENT 'TYP000',
  `n_spid` int(6) unsigned NOT NULL DEFAULT 0 COMMENT 'sch pid',
  `n_cpid2` int(6) unsigned NOT NULL DEFAULT 0 COMMENT 'cont pid',
  `n_delyn` enum('n','y') DEFAULT 'n' COMMENT '삭제여부',
  `n_created` datetime DEFAULT NULL,
  `n_createdip` varchar(64) DEFAULT NULL,
  `n_createdid` varchar(16) DEFAULT NULL,
  `n_modified` datetime DEFAULT NULL,
  `n_modifiedip` varchar(64) DEFAULT NULL,
  `n_modifiedid` varchar(16) DEFAULT NULL,
  `n_deleted` datetime DEFAULT NULL,
  `n_deletedip` varchar(64) DEFAULT NULL,
  `n_deletedid` varchar(16) DEFAULT NULL,
  PRIMARY KEY (`n_pid`) USING BTREE,
  KEY `nxo_box_idx` (`n_pid`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='box info';

-- 테이블 mspdb.nxo_code 구조 내보내기
CREATE TABLE IF NOT EXISTS `nxo_code` (
  `n_pid` int(6) unsigned NOT NULL AUTO_INCREMENT COMMENT 'pid',
  `n_cpid` int(3) unsigned NOT NULL COMMENT 'company pid',
  `n_pcode` varchar(6) NOT NULL DEFAULT '' COMMENT '부모코드',
  `n_code` varchar(6) NOT NULL DEFAULT '' COMMENT '코드',
  `n_name_org` varchar(100) NOT NULL DEFAULT '' COMMENT '코드명',
  `n_name` varchar(100) NOT NULL DEFAULT '' COMMENT '코드명 영문',
  `n_option` varchar(100) NOT NULL DEFAULT '' COMMENT '옵션',
  `n_option2` varchar(100) NOT NULL DEFAULT '' COMMENT '옵션2',
  `n_depth` int(2) unsigned NOT NULL COMMENT '깊이',
  `n_order` int(2) unsigned NOT NULL COMMENT '순서',
  `n_useyn` enum('y','n') DEFAULT 'y' COMMENT '샤용여부',
  `n_delyn` enum('n','y') DEFAULT 'n' COMMENT '삭제여부',
  `n_created` datetime DEFAULT NULL,
  `n_createdip` varchar(64) DEFAULT NULL,
  `n_createdid` varchar(16) DEFAULT NULL,
  `n_modified` datetime DEFAULT NULL,
  `n_modifiedip` varchar(64) DEFAULT NULL,
  `n_modifiedid` varchar(16) DEFAULT NULL,
  `n_deleted` datetime DEFAULT NULL,
  `n_deletedip` varchar(64) DEFAULT NULL,
  `n_deletedid` varchar(16) DEFAULT NULL,
  PRIMARY KEY (`n_pid`),
  UNIQUE KEY `nxo_code_unique` (`n_cpid`,`n_pcode`,`n_code`),
  KEY `nxo_code_idx` (`n_cpid`,`n_pcode`,`n_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='code info';

INSERT INTO `nxo_code` (`n_pid`, `n_cpid`, `n_pcode`, `n_code`, `n_name_org`, `n_name`, `n_option`, `n_option2`, `n_depth`, `n_order`, `n_useyn`, `n_delyn`, `n_created`, `n_createdip`, `n_createdid`, `n_modified`, `n_modifiedip`, `n_modifiedid`, `n_deleted`, `n_deletedip`, `n_deletedid`) VALUES
	(1, 1, 'ACT000', 'ACT000', '액션', 'Action', '', '', 0, 0, 'y', 'n', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(2, 1, 'ACT000', 'ACT001', '등록', 'Add', '', '', 1, 1, 'y', 'n', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(3, 1, 'ACT000', 'ACT002', '수정', 'Edit', '', '', 1, 2, 'y', 'n', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(4, 1, 'ACT000', 'ACT003', '삭제', 'Delete', '', '', 1, 3, 'y', 'n', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(5, 1, 'ACT000', 'ACT004', '파일등록', 'File Add', '', '', 1, 4, 'y', 'n', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(6, 1, 'ACT000', 'ACT005', '파일삭제', 'File Delete', '', '', 1, 5, 'y', 'n', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(7, 1, 'CNT000', 'CNT000', '컨텐츠종류', 'Content Type', '', '', 0, 0, 'y', 'n', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(8, 1, 'CNT000', 'CNT001', '동영상', 'Movie', '', '', 1, 1, 'y', 'n', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(9, 1, 'CNT000', 'CNT002', '이미지', 'Image', '', '', 1, 2, 'y', 'n', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(10, 1, 'CNT000', 'CNT003', '게시판', 'Board', '', '', 1, 3, 'y', 'n', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(11, 1, 'CNT000', 'CNT004', 'PDF', 'PDF', '', '', 1, 4, 'y', 'n', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(12, 1, 'CNT000', 'CNT005', 'PPT', 'PPT', '', '', 1, 5, 'y', 'n', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(13, 1, 'CNT000', 'CNT006', 'Youtube', 'Youtube', '', '', 1, 6, 'y', 'n', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(14, 1, 'CNT000', 'CNT007', 'Flash', 'Flash', '', '', 1, 7, 'y', 'n', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(15, 1, 'CNT000', 'CNT008', 'HTML', 'HTML', '', '', 1, 8, 'y', 'n', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(16, 1, 'CNT000', 'CNT009', '기타', 'Etc', '', '', 1, 9, 'y', 'n', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(17, 1, 'CNT000', 'CNT010', 'tv', 'TV', '', '', 1, 10, 'y', 'n', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(18, 1, 'CNT000', 'CNT011', 'Welcome', 'Welcome', '', '', 1, 10, 'y', 'n', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(19, 1, 'CTV000', 'CTV000', 'CCTV', 'CCTV', '', '', 0, 0, 'y', 'n', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(20, 1, 'LCS000', 'LCS000', '라이센스타입', 'License', '', '', 0, 0, 'y', 'n', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(21, 1, 'LCS000', 'LCS001', '로컬', 'Local', '', '', 1, 1, 'y', 'n', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(22, 1, 'LCS000', 'LCS002', '웹', 'Web', '', '', 1, 2, 'y', 'n', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(23, 1, 'LVL000', 'LVL000', '관리자등급', 'Level', '', '', 0, 0, 'y', 'n', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(24, 1, 'LVL000', 'LVL001', '슈퍼관리자', 'Super Manager', '', '', 1, 1, 'y', 'n', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(25, 1, 'LVL000', 'LVL002', '컨텐츠관리자', 'Contents Manager', '', '', 1, 2, 'y', 'n', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(26, 1, 'MOD000', 'MOD000', '장치모드', 'Device Mode', '', '', 0, 0, 'y', 'n', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(27, 1, 'MOD000', 'MOD001', '일반', 'General', '', '', 1, 1, 'y', 'n', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(28, 1, 'RES000', 'RES000', '해상도', 'Resolution', '', '', 0, 0, 'y', 'n', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(29, 1, 'RES000', 'RES001', '1080x1920', '1080x1920', '', '', 1, 1, 'y', 'n', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(30, 1, 'RES000', 'RES002', '1920x1080', '1920x1080', '', '', 1, 2, 'y', 'n', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(31, 1, 'RES000', 'RES003', '1024x768', '1024x768', '', '', 1, 3, 'y', 'n', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(32, 1, 'RES000', 'RES004', '768x1024', '768x1024', '', '', 1, 4, 'y', 'n', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(33, 1, 'RES000', 'RES005', '7680x2160', '7680x2160', '', '', 1, 5, 'y', 'n', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(34, 1, 'RES000', 'RES006', '3840x1760', '3840x1760', '', '', 1, 6, 'y', 'n', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(35, 1, 'TYP000', 'TYP000', '메뉴타입', 'Menu', '', '', 0, 0, 'y', 'n', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(36, 1, 'TYP000', 'TYP001', '스케쥴', 'Schedule', '', '', 1, 1, 'y', 'n', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(37, 1, 'TYP000', 'TYP002', '동영상', 'Movie', '', '', 1, 2, 'y', 'n', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(38, 1, 'TYP000', 'TYP003', '이미지', 'Image', '', '', 1, 3, 'y', 'n', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(39, 1, 'TYP000', 'TYP004', '시간', 'Clock', '', '', 1, 4, 'y', 'n', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(40, 1, 'TYP000', 'TYP005', '날씨', 'Weather', '', '', 1, 5, 'y', 'n', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(41, 1, 'TYP000', 'TYP006', '고정', 'Fix', '', '', 1, 6, 'y', 'n', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(42, 1, 'TYP000', 'TYP007', '공지사항', 'Notice', '', '', 1, 7, 'y', 'n', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(43, 1, 'DEV000', 'DEV000', '그룹1', '그룹1', '', '', 0, 0, 'y', 'n', NULL, NULL, NULL, '2024-01-22 09:35:51', '::1', 'admin', NULL, NULL, NULL),
	(44, 1, 'DEV000', 'DEV001', '기기1', '기기1', '1080x1920', '', 1, 1, 'y', 'n', NULL, NULL, NULL, '2024-01-22 09:32:25', '::1', 'admin', NULL, NULL, NULL),
	(45, 1, 'MNU000', 'MNU000', '키오스크메뉴', 'Kiosk', '', '', 0, 0, 'y', 'n', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(46, 1, 'MNU000', 'MNU001', '홈', 'Home', '', '', 1, 1, 'y', 'n', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(47, 1, 'MNU000', 'MNU002', '오피스', 'Office', '', '', 1, 2, 'y', 'n', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(48, 1, 'MNU000', 'MNU003', '어메니티', 'Amanity', '', '', 1, 3, 'y', 'n', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(49, 1, 'MNU000', 'MNU004', '공지사항', 'Notcie', '', '', 1, 4, 'y', 'n', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(50, 1, 'MNU000', 'MNU005', '교통안내', 'Transport', '', '', 1, 5, 'y', 'n', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(51, 1, 'DEV002', 'DEV002', '', '그룹2', '', '', 0, 0, 'y', 'n', '2024-06-11 10:32:01', '61.43.143.118', 'admin', NULL, NULL, NULL, NULL, NULL, NULL),
	(52, 1, 'DEV002', 'DEV003', '', '기기2', '1024x768', '', 1, 1, 'y', 'n', '2024-06-11 10:32:18', '61.43.143.118', 'admin', NULL, NULL, NULL, NULL, NULL, NULL);

-- 테이블 mspdb.nxo_company 구조 내보내기
CREATE TABLE IF NOT EXISTS `nxo_company` (
  `n_pid` int(3) unsigned NOT NULL AUTO_INCREMENT,
  `n_name` varchar(255) DEFAULT NULL COMMENT '회사명',
  `n_zipcode` varchar(6) DEFAULT NULL COMMENT '우편번호',
  `n_addr` varchar(255) DEFAULT NULL COMMENT '주소',
  `n_addr2` varchar(255) DEFAULT NULL COMMENT '상세주소',
  `n_tel` varchar(24) DEFAULT NULL COMMENT '대표전화',
  `n_fax` varchar(24) DEFAULT NULL COMMENT '팩스',
  `n_regno` varchar(255) DEFAULT NULL COMMENT '사업자등록번호',
  `n_singono` varchar(255) DEFAULT NULL COMMENT '통신판매업 신고번호',
  `n_ceo` varchar(64) DEFAULT NULL COMMENT '대표자명',
  `n_charger` varchar(64) DEFAULT NULL COMMENT '책임자명',
  `n_bi` varchar(255) DEFAULT NULL COMMENT 'bi',
  `n_cctv` varchar(100) DEFAULT NULL COMMENT 'cctv timer',
  `n_content` varchar(100) DEFAULT NULL COMMENT 'content timer',
  `n_pcoff` enum('0','1') DEFAULT '0' COMMENT 'pcoff가능여부',
  `n_autoreboot` enum('0','1') DEFAULT '0' COMMENT '자동재시작여부',
  `n_time` varchar(6) DEFAULT NULL COMMENT '자동재시작시간',
  `n_closetime` varchar(6) DEFAULT NULL COMMENT '종료시간',
  `n_lcs` varchar(255) DEFAULT NULL COMMENT '라이센스(암호화)',
  `n_lcscode` varchar(255) DEFAULT NULL COMMENT 'LCS000(암호화)',
  `n_version` varchar(255) DEFAULT NULL COMMENT '버전(암호화)',
  `n_ips` varchar(255) DEFAULT NULL COMMENT '제한아이피(암호화) , 로 구분',
  `n_macs` varchar(255) DEFAULT NULL COMMENT '제한맥(암호화)',
  `n_timeout` varchar(64) DEFAULT NULL COMMENT '자동로그아웃 일:시:분',
  `n_delyn` enum('y','n') DEFAULT 'n',
  `n_created` datetime DEFAULT NULL,
  `n_createdip` varchar(64) DEFAULT NULL,
  `n_createdid` varchar(16) DEFAULT NULL,
  `n_modified` datetime DEFAULT NULL,
  `n_modifiedip` varchar(64) DEFAULT NULL,
  `n_modifiedid` varchar(16) DEFAULT NULL,
  `n_deleted` datetime DEFAULT NULL,
  `n_deletedip` varchar(64) DEFAULT NULL,
  `n_deletedid` varchar(16) DEFAULT NULL,
  PRIMARY KEY (`n_pid`),
  KEY `nxo_company_idx` (`n_pid`,`n_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='company info';

INSERT INTO `nxo_company` (`n_pid`, `n_name`, `n_zipcode`, `n_addr`, `n_addr2`, `n_tel`, `n_fax`, `n_regno`, `n_singono`, `n_ceo`, `n_charger`, `n_bi`, `n_cctv`, `n_content`, `n_pcoff`, `n_autoreboot`, `n_time`, `n_closetime`, `n_lcs`, `n_lcscode`, `n_version`, `n_ips`, `n_macs`, `n_timeout`, `n_delyn`, `n_created`, `n_createdip`, `n_createdid`, `n_modified`, `n_modifiedip`, `n_modifiedid`, `n_deleted`, `n_deletedip`, `n_deletedid`) VALUES
	(1, '엠파트너스', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'assets/images/AdminLTELogo.png', '', '', '0', '0', '0000', '0000', 'cHVYaEs0cHloRXVCUHlxUG1sVzA3Uk80SUp6dno0ekdLSVQ5YmJWWXQ4ST0', 'MFBhVGRqTk5DcHp2N29kZUN2YUlCQT09', 'RzhFL3A1RWhPK0d3M1hPVWpVVHZudz09', 'RmtKTnhvcEhYUlRLbkdiNnFycDZzQT09', 'b3Y1dkNMb2pIUCtXZ1VLUWlOT0RpSG1tcG1NTit5MmNtMitGRURDMmI2WT0', '365:0:0', 'n', NULL, NULL, NULL, '2024-01-22 16:12:44', '::1', 'admin', NULL, NULL, NULL);

-- 테이블 mspdb.nxo_content 구조 내보내기
CREATE TABLE IF NOT EXISTS `nxo_content` (
  `n_pid` int(6) unsigned NOT NULL AUTO_INCREMENT,
  `n_cpid` int(3) unsigned DEFAULT NULL COMMENT '회사 pid',
  `n_mnucode` varchar(6) DEFAULT NULL COMMENT 'DEV000',
  `n_title` varchar(255) DEFAULT NULL COMMENT '컨텐츠명',
  `n_name` varchar(255) DEFAULT NULL COMMENT '등록자',
  `n_cntcode` varchar(6) DEFAULT NULL COMMENT 'CNT000',
  `n_file` varchar(255) DEFAULT NULL COMMENT '파일 경로 혹 url',
  `n_thumb` varchar(255) DEFAULT NULL COMMENT 'thumb url',
  `n_time` varchar(255) DEFAULT NULL COMMENT '지속시간',
  `n_content` text DEFAULT NULL COMMENT '파일내용',
  `n_sday` varchar(8) DEFAULT NULL COMMENT '시작일',
  `n_eday` varchar(8) DEFAULT NULL COMMENT '마감일',
  `n_stime` varchar(2) DEFAULT NULL COMMENT '시작시간',
  `n_etime` varchar(2) DEFAULT NULL COMMENT '마감시간',
  `n_order` int(3) unsigned DEFAULT 0 COMMENT '순서',
  `n_size` int(11) unsigned DEFAULT 0 COMMENT '파일크기',
  `n_cnt` int(3) unsigned DEFAULT 1 COMMENT '파일갯수',
  `n_delyn` enum('y','n') DEFAULT 'n',
  `n_created` datetime DEFAULT NULL,
  `n_createdip` varchar(64) DEFAULT NULL,
  `n_createdid` varchar(16) DEFAULT NULL,
  `n_modified` datetime DEFAULT NULL,
  `n_modifiedip` varchar(64) DEFAULT NULL,
  `n_modifiedid` varchar(16) DEFAULT NULL,
  `n_deleted` datetime DEFAULT NULL,
  `n_deletedip` varchar(64) DEFAULT NULL,
  `n_deletedid` varchar(16) DEFAULT NULL,
  PRIMARY KEY (`n_pid`),
  KEY `nxo_content_idx` (`n_pid`,`n_cpid`,`n_title`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='content info';

-- 테이블 mspdb.nxo_contentlog 구조 내보내기
CREATE TABLE IF NOT EXISTS `nxo_contentlog` (
  `n_pid` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT 'pid',
  `n_cpid` int(11) NOT NULL DEFAULT 0 COMMENT 'company pid',
  `n_bpid` int(11) NOT NULL DEFAULT 0 COMMENT 'content pid',
  `n_actcode` varchar(6) DEFAULT NULL COMMENT 'ACT000',
  `n_mnucode` varchar(6) DEFAULT NULL COMMENT 'DEV000',
  `n_title` varchar(255) DEFAULT NULL COMMENT '제목',
  `n_name` varchar(255) DEFAULT NULL COMMENT '등록자',
  `n_content` text DEFAULT NULL COMMENT '내용',
  `n_file` varchar(255) DEFAULT NULL COMMENT '게시물',
  `n_sday` varchar(8) DEFAULT NULL COMMENT '시작일',
  `n_eday` varchar(8) DEFAULT NULL COMMENT '마감일',
  `n_stime` varchar(2) DEFAULT NULL COMMENT '시작시간',
  `n_etime` varchar(2) DEFAULT NULL COMMENT '마감시간',
  `n_time` varchar(255) DEFAULT NULL COMMENT '지속시간',
  `n_order` int(3) unsigned DEFAULT 0 COMMENT '순서',
  `n_size` int(11) unsigned DEFAULT 0 COMMENT '파일크기',
  `n_cnt` int(3) unsigned DEFAULT 1 COMMENT '파일갯수',
  `n_created` datetime DEFAULT NULL,
  `n_createdip` varchar(64) DEFAULT NULL,
  `n_createdid` varchar(16) DEFAULT NULL,
  PRIMARY KEY (`n_pid`) USING BTREE,
  KEY `nxo_content_log_idx` (`n_pid`,`n_actcode`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='contentlog info';

-- 테이블 mspdb.nxo_manager 구조 내보내기
CREATE TABLE IF NOT EXISTS `nxo_manager` (
  `n_pid` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `n_cpid` int(11) unsigned DEFAULT NULL COMMENT '회사 pid',
  `n_lvlcode` varchar(6) DEFAULT NULL COMMENT 'LVL000',
  `n_id` varchar(255) DEFAULT NULL COMMENT '아이디',
  `n_pw` varchar(255) DEFAULT NULL COMMENT '패스워드',
  `n_name` varchar(255) DEFAULT NULL COMMENT '이름',
  `n_hp` varchar(255) DEFAULT NULL COMMENT '핸드폰',
  `n_email` varchar(255) DEFAULT NULL COMMENT '이메일',
  `n_device` varchar(255) DEFAULT NULL COMMENT 'device with comma',
  `n_delyn` enum('y','n') DEFAULT 'n',
  `n_created` datetime DEFAULT NULL,
  `n_createdip` varchar(64) DEFAULT NULL,
  `n_createdid` varchar(16) DEFAULT NULL,
  `n_modified` datetime DEFAULT NULL,
  `n_modifiedip` varchar(64) DEFAULT NULL,
  `n_modifiedid` varchar(16) DEFAULT NULL,
  `n_deleted` datetime DEFAULT NULL,
  `n_deletedip` varchar(64) DEFAULT NULL,
  `n_deletedid` varchar(16) DEFAULT NULL,
  PRIMARY KEY (`n_pid`),
  KEY `nxo_manager_idx` (`n_pid`,`n_cpid`,`n_lvlcode`,`n_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='manager info';

INSERT INTO `nxo_manager` (`n_pid`, `n_cpid`, `n_lvlcode`, `n_id`, `n_pw`, `n_name`, `n_hp`, `n_email`, `n_device`, `n_delyn`, `n_created`, `n_createdip`, `n_createdid`, `n_modified`, `n_modifiedip`, `n_modifiedid`, `n_deleted`, `n_deletedip`, `n_deletedid`) VALUES
	(1, 1, 'LVL001', 'admin', '*D58377918AB4851B16D1969E59A8D9B523B12ABC', 'Manager', '', '', '', 'n', '0000-00-00 00:00:00', NULL, NULL, '2024-02-06 04:46:59', '::1', 'admin', NULL, NULL, NULL),
	(2, 1, 'LVL002', 'admin1', '*D58377918AB4851B16D1969E59A8D9B523B12ABC', 'local manager', '', '', 'DEV001,DEV002,DEV003', 'y', '2023-08-30 12:39:16', '61.43.143.118', 'admin', NULL, NULL, NULL, '2024-06-11 10:32:40', '61.43.143.118', 'admin'),
	(3, 1, 'LVL002', 'admin1213', '*E7D72E29209E56AF5FC792E0DC72FC7479FB6A2B', '관리자', '', 'admin', 'DEV005,DEV008,DEV009,DEV010', 'y', '2024-01-22 11:10:18', '::1', 'admin', NULL, NULL, NULL, '2024-06-11 10:32:40', '61.43.143.118', 'admin'),
	(4, 1, 'LVL002', 'test', '*E7D72E29209E56AF5FC792E0DC72FC7479FB6A2B', '테스트관리자', '', '', 'DEV001', 'n', '2024-06-11 10:33:09', '61.43.143.118', 'admin', NULL, NULL, NULL, NULL, NULL, NULL);

-- 테이블 mspdb.nxo_monitoring 구조 내보내기
CREATE TABLE IF NOT EXISTS `nxo_monitoring` (
  `n_pid` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `n_cpid` int(11) unsigned DEFAULT NULL COMMENT '회사 pid',
  `n_devcode` varchar(6) DEFAULT NULL COMMENT 'DEV000',
  `n_modcode` varchar(6) DEFAULT NULL COMMENT 'MOD000',
  `n_ip` varchar(64) DEFAULT NULL COMMENT 'IP',
  `n_agency` enum('0','1') DEFAULT '1' COMMENT '0:off,1:on',
  `n_viewer` enum('0','1') DEFAULT '1' COMMENT '0:close,1:play',
  `n_download` int(3) DEFAULT NULL COMMENT 'download percent',
  `n_maincpid` int(11) DEFAULT NULL COMMENT '게시판현재실행컨텐츠',
  `n_playfilename` varchar(255) DEFAULT NULL COMMENT '엘리베이터 현재실행컨텐츠',
  `n_nowsche` varchar(255) DEFAULT NULL COMMENT '현재적용스케쥴',
  `n_newsche` varchar(255) DEFAULT NULL COMMENT '업데이트스케쥴',
  `n_newcontyn` enum('0','1') DEFAULT '0' COMMENT '메인컨텐츠 업데이트 여부 1:update',
  `n_newscheyn` enum('0','1') DEFAULT '0' COMMENT '스케쥴 업데이트 여부 1:update',
  `n_nowpage` varchar(255) DEFAULT NULL COMMENT '현재적용스케쥴',
  `n_pcoffyn` enum('0','1') DEFAULT '0' COMMENT 'pc종료',
  `n_pcrebootyn` enum('0','1') DEFAULT '0' COMMENT 'pc 재시작',
  `n_viewerstartyn` enum('0','1') DEFAULT '0' COMMENT 'viewer 시작',
  `n_vieweroffyn` enum('0','1') DEFAULT '0' COMMENT 'viewer 종료',
  `n_closetimeyn` enum('0','1') DEFAULT '0' COMMENT '종료시간사용여부',
  `n_closetime` varchar(32) DEFAULT NULL COMMENT '종료시간',
  `n_autorebootyn` enum('0','1') DEFAULT NULL,
  `n_autoreboottime` varchar(255) DEFAULT NULL,
  `n_res` varchar(12) DEFAULT NULL COMMENT '모니터해상도',
  `n_dir` enum('가로','세로') DEFAULT '세로' COMMENT '모니터방향',
  `n_mnucode` varchar(6) DEFAULT NULL COMMENT '현재서브메뉴',
  `n_delyn` enum('y','n') DEFAULT 'n' COMMENT '삭제여부',
  `n_created` datetime DEFAULT NULL,
  `n_createdip` varchar(64) DEFAULT NULL,
  `n_createdid` varchar(16) DEFAULT NULL,
  `n_modified` datetime DEFAULT NULL,
  `n_modifiedip` varchar(64) DEFAULT NULL,
  `n_modifiedid` varchar(16) DEFAULT NULL,
  `n_deleted` datetime DEFAULT NULL,
  `n_deletedip` varchar(64) DEFAULT NULL,
  `n_deletedid` varchar(16) DEFAULT NULL,
  PRIMARY KEY (`n_pid`),
  KEY `nxo_monitoring_idx` (`n_pid`,`n_cpid`,`n_devcode`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='monitoring info';

INSERT INTO `nxo_monitoring` (`n_pid`, `n_cpid`, `n_devcode`, `n_modcode`, `n_ip`, `n_agency`, `n_viewer`, `n_download`, `n_maincpid`, `n_playfilename`, `n_nowsche`, `n_newsche`, `n_newcontyn`, `n_newscheyn`, `n_nowpage`, `n_pcoffyn`, `n_pcrebootyn`, `n_viewerstartyn`, `n_vieweroffyn`, `n_closetimeyn`, `n_closetime`, `n_autorebootyn`, `n_autoreboottime`, `n_res`, `n_dir`, `n_mnucode`, `n_delyn`, `n_created`, `n_createdip`, `n_createdid`, `n_modified`, `n_modifiedip`, `n_modifiedid`, `n_deleted`, `n_deletedip`, `n_deletedid`) VALUES
	(1, 1, 'DEV001', 'MOD001', '61.43.143.118:62060', '1', '1', 100, NULL, NULL, 'sche_202407111326266364.xml', 'sche_202407111326266364.xml', '0', '0', '2', '0', '0', '0', '0', '0', NULL, NULL, NULL, NULL, '세로', NULL, 'n', '2022-06-30 12:35:33', '::1', 'admin', '2024-06-11 12:30:11', '61.43.143.118', 'admin', '2022-11-25 12:37:29', '::1', 'admin'),
	(2, 1, 'DEV003', 'MOD001', NULL, '0', '0', NULL, NULL, NULL, NULL, 'sche_202406260729287867.xml', '0', '0', '1', '0', '0', '0', '0', '0', NULL, NULL, NULL, NULL, '세로', NULL, 'n', '2024-06-11 10:32:18', '61.43.143.118', 'admin', '2024-06-11 16:10:43', '175.197.16.93', 'admin', NULL, NULL, NULL);

-- 테이블 mspdb.nxo_page 구조 내보내기
CREATE TABLE IF NOT EXISTS `nxo_page` (
  `n_pid` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT 'pid',
  `n_cpid` int(11) unsigned DEFAULT NULL COMMENT 'company pid',
  `n_title` varchar(255) DEFAULT NULL COMMENT 'page name',
  `n_rescode` varchar(6) DEFAULT NULL COMMENT 'RES000',
  `n_sche` varchar(255) DEFAULT NULL COMMENT 'xml file name',
  `n_delyn` enum('n','y') DEFAULT 'n' COMMENT '삭제여부',
  `n_created` datetime DEFAULT NULL,
  `n_createdip` varchar(64) DEFAULT NULL,
  `n_createdid` varchar(16) DEFAULT NULL,
  `n_modified` datetime DEFAULT NULL,
  `n_modifiedip` varchar(64) DEFAULT NULL,
  `n_modifiedid` varchar(16) DEFAULT NULL,
  `n_deleted` datetime DEFAULT NULL,
  `n_deletedip` varchar(64) DEFAULT NULL,
  `n_deletedid` varchar(16) DEFAULT NULL,
  PRIMARY KEY (`n_pid`) USING BTREE,
  KEY `nxo_page_idx` (`n_pid`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='page info';

-- 테이블 mspdb.nxo_sche 구조 내보내기
CREATE TABLE IF NOT EXISTS `nxo_sche` (
  `n_pid` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT 'pid',
  `n_cpid` int(11) unsigned DEFAULT NULL COMMENT 'company pid',
  `n_spid` int(11) unsigned DEFAULT NULL COMMENT 'schename pid',
  `n_bpid` int(11) unsigned DEFAULT NULL COMMENT 'content pid',
  `n_order` int(3) unsigned NOT NULL DEFAULT 0 COMMENT '순서',
  `n_time` varchar(255) DEFAULT NULL COMMENT '시간',
  `n_delyn` enum('n','y') DEFAULT 'n' COMMENT '삭제여부',
  `n_created` datetime DEFAULT NULL,
  `n_createdip` varchar(64) DEFAULT NULL,
  `n_createdid` varchar(16) DEFAULT NULL,
  `n_modified` datetime DEFAULT NULL,
  `n_modifiedip` varchar(64) DEFAULT NULL,
  `n_modifiedid` varchar(16) DEFAULT NULL,
  `n_deleted` datetime DEFAULT NULL,
  `n_deletedip` varchar(64) DEFAULT NULL,
  `n_deletedid` varchar(16) DEFAULT NULL,
  PRIMARY KEY (`n_pid`) USING BTREE,
  KEY `nxo_sche_idx` (`n_pid`,`n_bpid`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='sche info';

-- 테이블 mspdb.nxo_schename 구조 내보내기
CREATE TABLE IF NOT EXISTS `nxo_schename` (
  `n_pid` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT 'pid',
  `n_cpid` int(11) unsigned NOT NULL DEFAULT 0 COMMENT 'company pid',
  `n_title` varchar(255) DEFAULT NULL COMMENT 'schedule name',
  `n_sche` varchar(255) DEFAULT NULL COMMENT 'xml file name',
  `n_sday` varchar(8) DEFAULT NULL COMMENT '시작일',
  `n_eday` varchar(8) DEFAULT NULL COMMENT '마감일',
  `n_delyn` enum('n','y') DEFAULT 'n' COMMENT '삭제여부',
  `n_created` datetime DEFAULT NULL,
  `n_createdip` varchar(64) DEFAULT NULL,
  `n_createdid` varchar(16) DEFAULT NULL,
  `n_modified` datetime DEFAULT NULL,
  `n_modifiedip` varchar(64) DEFAULT NULL,
  `n_modifiedid` varchar(16) DEFAULT NULL,
  `n_deleted` datetime DEFAULT NULL,
  `n_deletedip` varchar(64) DEFAULT NULL,
  `n_deletedid` varchar(16) DEFAULT NULL,
  PRIMARY KEY (`n_pid`) USING BTREE,
  KEY `nxo_schename_idx` (`n_pid`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='schename info';

DELIMITER //
CREATE FUNCTION `FNC_GET_CODENAME`(code VARCHAR(6), cpid INT(3)) RETURNS varchar(100) CHARSET utf8mb4 COLLATE utf8mb4_general_ci
BEGIN
  DECLARE name VARCHAR(100);

  SELECT n_name INTO name FROM nxo_code WHERE n_code = code AND n_cpid = cpid;

  RETURN name;
END//
DELIMITER ;

DELIMITER //
CREATE FUNCTION `FNC_GET_CONTTITLE`(pid INT(11), cpid INT(3)) RETURNS varchar(255) CHARSET utf8mb4 COLLATE utf8mb4_general_ci
BEGIN
  DECLARE title VARCHAR(255);

  SELECT n_title INTO title FROM nxo_content WHERE n_pid = pid AND n_cpid = cpid;

  RETURN title;
END//
DELIMITER ;

DELIMITER //
CREATE FUNCTION `FNC_GET_PCODENAME`(code VARCHAR(6), cpid INT(3)) RETURNS varchar(100) CHARSET utf8mb4 COLLATE utf8mb4_general_ci
BEGIN
  DECLARE pcode VARCHAR(6);
  DECLARE name VARCHAR(100);

  SELECT n_pcode INTO pcode FROM nxo_code WHERE n_code = code AND n_cpid = cpid;
  SELECT n_name INTO name FROM nxo_code WHERE n_code = pcode AND n_cpid = cpid;

  RETURN name;
END//
DELIMITER ;
